% MATLAB Demo code for object matching of ICCV 2009 paper
%
% Minsu Cho, Jungmin Lee, and Kyoung Mu Lee, 
% Feature Correspondence and Deformable Object Matching via Agglomerative Correspondence Clustering, 
% Proc. International Conference on Computer Vision (ICCV), 2009.
% 
% Note that this is a simple MATLAB implementation without consideration for speed-up. 
%
% written by Minsu Cho, 2009, Seoul National University, Korea
% http://cv.snu.ac.kr/~minsucho

clear all;
% load settings
eval('config_file');
% load initial matches and compute an affinity matrix
[iparam, cdata] = do_init( iparam );
% perform correspondence selection and clustering
tic;
[ cdata ] = agglomerate_corres( iparam, cdata );
toc;
% display results
show_results;