function [ iparam, cdata ] = do_init( iparam ) 
% initialization funtion for ACC

bPair = size(iparam.view,2) == 2;
view1 = 1;    view2 = size(iparam.view,2);

disp('* Loading match information...');
% load match information with view information
%
% cdata.view(1:2) - view information of each view (1 or 2)
% cdata.view(1:2).feat(:,1:5)      = [ u, v, a, b, c ]
% cdata.view(1:2).affMatrix(:,1:9) = 3 by 3 affine trasformation 
%                                  = from the unit circle to the region
%
% cdata.matchInfo(:) - match information for each match
% cdata.matchInfo(:).match = [ row index at cdata.view(1).feat,  row index at cdata.view(2).feat ]

path_matchFile = [ iparam.matchFolder '/' 'match_' iparam.view(view1).fileName '+' iparam.view(view2).fileName '.mat' ];
load(path_matchFile,'viewInfo','matchInfo');
cdata.view = viewInfo;
cdata.matchInfo = matchInfo;
clear viewInfo matchInfo
cdata.nInitialMatches = size(cdata.matchInfo,2);
cdata.bPair = bPair;
disp([ '- num of initial matches: ' num2str(cdata.nInitialMatches) ]);

if bPair
    imgInput = appendimages( cdata.view(1).img, cdata.view(2).img );
else
    imgInput = cdata.view(1).img;
end
figure; imshow(imgInput);   title('Input');

if iparam.bShowInitialMatches
    display_initial_ACR( iparam, cdata );
end

disp('* Computing affinities between initial matches...');
tic;
% caculate affinity matrix of initial matches based on transform error
[ cdata.affinityMatrix cdata.overlapMatrix ] = compute_affinedistance( ...
    cdata.view(view1), cdata.view(view2), cdata.matchInfo(1:cdata.nInitialMatches) );
nOverlap = sum(sum(cdata.overlapMatrix));
fprintf('- %d (%4.2f%%) overlapping matches detected among %d combination pairs\n', nOverlap, nOverlap/cdata.nInitialMatches^2,cdata.nInitialMatches^2 );
cdata.nSeed = cdata.nInitialMatches;

%% Cluster Information & Mergence Tree
% clusterInfo(:).id                 : id of the cluster i.e. 1, 2, 3,...
% clusterInfo(:).color              : color of the cluster as RGB values [ R G B ]
% clusterInfo(:).centroid           : the centroid of the cluster

for i=1:cdata.nSeed
    cdata.clusterInfo(i).id = i; % unique id of this cluster
    cdata.clusterInfo(i).seedIdx = [ i ]; %  seed idx contained in this cluster
    cdata.clusterInfo(i).size = 1; % total grown match size in this cluster
    cdata.clusterInfo(i).color = rand(1,3); % color of this cluster

    tmpMatch = cdata.matchInfo(i).match;
    cdata.clusterInfo(i).centroid_A = [ cdata.view(view1).feat(tmpMatch(1),1:2) ]; 
    cdata.clusterInfo(i).centroid_B = [ cdata.view(view2).feat(tmpMatch(2),1:2) ]; 
end

cdata.nCluster = cdata.nSeed;
fprintf('- Initial information constructed... %f secs\n',toc);  

end
