function display_result_ACR( iparam, cdata )
% display function for result

sizeThres = 3;
% img to visualize & its size
if cdata.bPair
    viewA = 1;  viewB = 2;
    imgInput = appendimages( cdata.view(1).img, cdata.view(2).img );
else
    viewA = 1;  viewB = 1;
    imgInput = [ cdata.view(1).img ];
end
areaImg1 = size(cdata.view(viewA).img,1) * size(cdata.view(viewA).img,2);
areaImg2 = size(cdata.view(viewB).img,1) * size(cdata.view(viewB).img,2);
% convert to double
imgInput = double(imgInput)./255;
imgInput = imresize(imgInput,iparam.resizeRatio);

% traverse from the largest
nFinalCluster = size(cdata.clusterInfo,2);
[ temp traversalIdx ] = sort([ cdata.clusterInfo.size ],'descend');
clear temp;

cCol = 0;
hFigMain1 = figure(5001);    set( gca,'Position',[0,0,1,1]); 
hFigMain2 = figure(5002);    set( gca,'Position',[0,0,1,1]); 

%% traverse all the clusters, and check their validity
for k=1:nFinalCluster
    cIdx = traversalIdx(k);

    % find cluster's matches
    matchIdxInTheCluster = cdata.clusterInfo(cIdx).seedIdx;
    curMatchList = cell2mat({ cdata.matchInfo(matchIdxInTheCluster).match }');
    idxFeatA = curMatchList(:,1);   idxFeatB = curMatchList(:,2);
    feat1= cdata.view(viewA).feat(idxFeatA,:); feat2= cdata.view(viewB).feat(idxFeatB,:); 

    cdata.clusterInfo(cIdx).bValid = 0;   
    cdata.clusterInfo(cIdx).forePixels{1} = [];
    cdata.clusterInfo(cIdx).forePixels{2} = [];
    cdata.clusterInfo(cIdx).convexHull{1} = [];
    cdata.clusterInfo(cIdx).convexHull{2} = [];
    
    if cdata.clusterInfo(cIdx).size < sizeThres,    continue;   end

    % find forepixels for each valid cluster
    foreMaskA = zeros(size(cdata.view(viewA).img,1), size(cdata.view(viewA).img,2));
    foreMaskB = zeros(size(cdata.view(viewB).img,1), size(cdata.view(viewB).img,2));

    for i=1:1:size(feat1,1)
        featA = feat1(i, :);
        xLength = ceil( sqrt( featA(5)/(featA(3)*featA(5)-featA(4)^2) ) );
        yLength = ceil( sqrt( featA(3)/(featA(3)*featA(5)-featA(4)^2) ) );
        checkRangeX = max(floor(featA(1) - xLength),1):min(ceil(featA(1) + xLength),size(foreMaskA,2) );
        checkRangeY = max(floor(featA(2) - yLength),1):min(ceil(featA(2) + yLength),size(foreMaskA,1) );
        [roiX,roiY] = meshgrid(checkRangeX,checkRangeY);
        roiZ = ( featA(3)*(roiX-featA(1)).^2 + 2*featA(4)*(roiX-featA(1)).*(roiY-featA(2)) + featA(5)*(roiY-featA(2)).^2 ) <= 1;
        foreMaskA(checkRangeY,checkRangeX) = foreMaskA(checkRangeY,checkRangeX) | roiZ;

        featB = feat2(i, :);
        xLength = ceil( sqrt( featB(5)/(featB(3)*featB(5)-featB(4)^2) ) );
        yLength = ceil( sqrt( featB(3)/(featB(3)*featB(5)-featB(4)^2) ) );
        checkRangeX = max(floor(featB(1) - xLength),1):min(ceil(featB(1) + xLength),size(foreMaskB,2) );
        checkRangeY = max(floor(featB(2) - yLength),1):min(ceil(featB(2) + yLength),size(foreMaskB,1) );
        [roiX,roiY] = meshgrid(checkRangeX,checkRangeY);
        roiZ = ( featB(3)*(roiX-featB(1)).^2 + 2*featB(4)*(roiX-featB(1)).*(roiY-featB(2)) + featB(5)*(roiY-featB(2)).^2 ) <= 1;
        foreMaskB(checkRangeY,checkRangeX) = foreMaskB(checkRangeY,checkRangeX) | roiZ;

    end
    cdata.clusterInfo(cIdx).forePixels{1} = find(foreMaskA);
    cdata.clusterInfo(cIdx).forePixels{2} = find(foreMaskB);
    minAreaRatio1 = min(nnz(foreMaskA)/areaImg1,nnz(foreMaskB)/areaImg2);

    % calculae convex hull of clusters
    hullFeat1 = []; hullFeat2 = [];
    minAreaRatio2 = 0;
    if size(unique(feat1(:,1:2),'rows'),1) > 2 && size(unique(feat2(:,1:2),'rows'),1) > 2
        idxHull1 = convhull(feat1(:,1),feat1(:,2),{'Qt','Pp'});
        hullFeat1 = feat1(idxHull1,:);
        areaHull1 = polyarea(hullFeat1(:,1),hullFeat1(:,2));
        idxHull2 = convhull(feat2(:,1),feat2(:,2),{'Qt','Pp'});
        hullFeat2 = feat2(idxHull2,:);
        areaHull2 = polyarea(hullFeat2(:,1),hullFeat2(:,2));
        minAreaRatio2 = min(areaHull1/areaImg1,areaHull2/areaImg2);
    end
    cdata.clusterInfo(cIdx).convexHull{1} = hullFeat1;
    cdata.clusterInfo(cIdx).convexHull{2} = hullFeat2;
    
    % check validity
    % tagging validity of clusters, with color
    if minAreaRatio2 >= iparam.areaThres && minAreaRatio1 >= iparam.areaThres
        cdata.clusterInfo(cIdx).bValid = 1; 
        if  cCol < size(iparam.colorOrder,2) 
            cCol = cCol + 1;
            cdata.clusterInfo(cIdx).color = iparam.colorOrder(cCol);
        end
    else
        cdata.clusterInfo(cIdx).bValid = 0; 
        cdata.clusterInfo(cIdx).color = 'k';
    end
end

%% make a ROI masked image
if iparam.bMasking
    foreMaskA = zeros(size(cdata.view(viewA).img,1), size(cdata.view(viewA).img,2));
    foreMaskB = zeros(size(cdata.view(viewB).img,1), size(cdata.view(viewB).img,2)); 
    for k=1:nFinalCluster
        if ~cdata.clusterInfo(traversalIdx(k)).bValid
            continue;
        end
        foreMaskA( cdata.clusterInfo(traversalIdx(k)).forePixels{1} ) = 1;
        foreMaskB( cdata.clusterInfo(traversalIdx(k)).forePixels{2} ) = 1;
    end
    if cdata.bPair % append two masks
        foreMask = appendimages(foreMaskA, foreMaskB);
    else
        foreMask = foreMaskA | foreMaskB;
    end
    % make background faded
    f = @(x) imadjust(x,[],[],0.15);
    foreMask = imresize(foreMask,iparam.resizeRatio,'nearest'); 
    imgMasked = zeros( size(foreMask,1), size(foreMask,2), 3);
    for i=1:3
        imgMasked(:,:,i) = roifilt2(imgInput(:,:,i),~foreMask,f);
    end
else
    imgMasked = imgInput;
end

                
%% Visualize clusters with contours, traversing all the clusters
set(0,'CurrentFigure',hFigMain1);   imshow(imgMasked);  set( gca,'Position',[0,0,1,1]); 
set(0,'CurrentFigure',hFigMain2);   imshow(imgMasked);  set( gca,'Position',[0,0,1,1]); 

for k=1:nFinalCluster
    cIdx = traversalIdx(k); 
    if ~cdata.clusterInfo(cIdx).bValid,    continue;   end
    
    col = cdata.clusterInfo(cIdx).color;
    % find cluster's matches
    matchIdxInTheCluster = cdata.clusterInfo(cIdx).seedIdx; 
    curMatchList = cell2mat({ cdata.matchInfo(matchIdxInTheCluster).match }');
    idxFeatA = curMatchList(:,1);   idxFeatB = curMatchList(:,2);
    feat1= cdata.view(viewA).feat(idxFeatA,:); feat2= cdata.view(viewB).feat(idxFeatB,:); 
    if cdata.bPair 
        feat2(:,1) = feat2(:,1) + size(cdata.view(1).img,2);
    end
    % consider the resizing factor
    feat1(:,1:2) = iparam.resizeRatio * feat1(:,1:2); 
    feat1(:,3:5) = 1/iparam.resizeRatio^2 * feat1(:,3:5); 
    feat2(:,1:2) = iparam.resizeRatio * feat2(:,1:2); 
    feat2(:,3:5) = 1/iparam.resizeRatio^2 * feat2(:,3:5); 
        
    % 1st view --------------------------------------------------------
    set(0,'CurrentFigure',hFigMain1);        hold on; 
    
    plot( feat1(:,1),feat1(:,2),'-o','LineWidth',1,'LineStyle','none','MarkerSize',10....
    ,'MarkerEdgeColor','w','MarkerFaceColor','w');
    plot( feat1(:,1),feat1(:,2),'-o','LineWidth',1,'LineStyle','none','MarkerSize',5....
    ,'MarkerEdgeColor',col,'MarkerFaceColor',col);
    plot( feat2(:,1),feat2(:,2),'-s','LineWidth',1,'LineStyle','none','MarkerSize',10....
    ,'MarkerEdgeColor','w','MarkerFaceColor','w');
    plot( feat2(:,1),feat2(:,2),'-s','LineWidth',1,'LineStyle','none','MarkerSize',5....
    ,'MarkerEdgeColor',col,'MarkerFaceColor',col); 
    
    % show convex hulls
    hullFeat1 = cdata.clusterInfo(cIdx).convexHull{1};
    hullFeat2 = cdata.clusterInfo(cIdx).convexHull{2};
    if length(hullFeat1) > 0
        if cdata.bPair
                hullFeat2(:,1) = hullFeat2(:,1) + size(cdata.view(1).img,2);
        end
        
        hullFeat1 = iparam.resizeRatio * hullFeat1; 
        hullFeat2 = iparam.resizeRatio * hullFeat2; 
        plot(hullFeat1(:,1),hullFeat1(:,2),'Color','w', 'LineWidth',6);
        plot(hullFeat1(:,1),hullFeat1(:,2),'Color',col,'LineWidth',3);
        plot(hullFeat2(:,1),hullFeat2(:,2),'Color','w', 'LineWidth',6);
        plot(hullFeat2(:,1),hullFeat2(:,2),'Color',col,'LineWidth',3);
    end

    % show centroids of clusters
    if iparam.bShowCentroids
        cent_A = cdata.clusterInfo(cIdx).centroid_A;
        cent_B = cdata.clusterInfo(cIdx).centroid_B;
        if cdata.bPair
                cent_B = cent_B + [ size(cdata.view(1).img,2), 0 ];                    
        end
        cent_A = resizeRatio * cent_A; 
        cent_B = resizeRatio * cent_B; 
        plot(cent_A(1), cent_A(2), ...
            '-o','LineWidth',1,'MarkerSize',15,'MarkerFaceColor', 'w');
        plot(cent_A(1), cent_A(2), ...
            '-o','LineWidth',1,'MarkerSize',10,'MarkerFaceColor', col);
        plot(cent_B(1), cent_B(2), ...
            '-o','LineWidth',1,'MarkerSize',15,'MarkerFaceColor', 'w');
        plot(cent_B(1), cent_B(2), ...
            '-o','LineWidth',1,'MarkerSize',10,'MarkerFaceColor', col); 
    end

    fprintf('MCS%2d (idx%3d) - col: %s  match num: %d\n',k,cIdx,...
        col, cdata.clusterInfo(cIdx).size);

    %% 2nd View --------------------------------------------------------
    set(0,'CurrentFigure',hFigMain2);        hold on;
    for i=1:size(feat1,1)
        if iparam.bShowMatchingLines
         plot([ feat1(i,1), feat2(i,1) ], [ feat1(i,2), feat2(i,2) ],...
                '-','LineWidth',1,'MarkerSize',10,...
                'color', col);%phase_weight*col);%cdata.clusterInfo(cIdx).color);
        end
         drawellipse3( feat1(i,1:5), 1, cdata.clusterInfo(cIdx).color,2);
         draworientation3( feat1(i,1:6), 1, cdata.clusterInfo(cIdx).color,2);
         drawellipse3( feat2(i,1:5) ,1, cdata.clusterInfo(cIdx).color,2);
         draworientation3( feat2(i,1:6) ,1, cdata.clusterInfo(cIdx).color,2);
    end

    if iparam.bPause
        fprintf('---- MCS %d, cluster idx: %d\n',k, cIdx);    pause;
    end

end

hold off;
    
end

