function display_initial_ACR( iparam, cdata )
% display function for initial matches

% img to visualize & its size
if size(iparam.view,2) == 2
    viewA = 1;  viewB = 2;
    imgInput = appendimages( cdata.view(1).img, cdata.view(2).img );
else
    viewA = 1;  viewB = 1;
    imgInput = cdata.view(1).img;
end
areaImg1 = size(cdata.view(viewA).img,1) * size(cdata.view(viewA).img,2);
areaImg2 = size(cdata.view(viewB).img,1) * size(cdata.view(viewB).img,2);
% convert to double
imgInput = double(imgInput)./255;
imgInput = imresize(imgInput,iparam.resizeRatio);

figure;
if size(imgInput,3) > 1
    imgInput = rgb2gray(imgInput);
end
imshow(imgInput);

hold on;
curMatchList = cell2mat({ cdata.matchInfo(1:cdata.nInitialMatches).match }');
idxFeatA = curMatchList(:,1);   idxFeatB = curMatchList(:,2);
feat1= cdata.view(viewA).feat(idxFeatA,:); feat2= cdata.view(viewB).feat(idxFeatB,:); 
if cdata.bPair 
    feat2(:,1) = feat2(:,1) + size(cdata.view(1).img,2);
end
% consider the resizing factor
feat1(:,1:2) = iparam.resizeRatio * feat1(:,1:2); 
feat1(:,3:5) = 1/iparam.resizeRatio^2 * feat1(:,3:5); 
feat2(:,1:2) = iparam.resizeRatio * feat2(:,1:2); 
feat2(:,3:5) = 1/iparam.resizeRatio^2 * feat2(:,3:5); 

for i=1:cdata.nInitialMatches
     plot([ feat1(i,1), feat2(i,1) ], [ feat1(i,2), feat2(i,2) ],...
                '-','LineWidth',1,'MarkerSize',10,'Color', 'y');
     drawellipse3( feat1(i,1:5), 1, 'r',2);
     draworientation3( feat1(i,1:6), 1, 'r',2);
     drawellipse3( feat2(i,1:5) ,1, 'r',2);
     draworientation3( feat2(i,1:6) ,1, 'r',2);
end
hold off;
title([ num2str(cdata.nInitialMatches) 'initial matches']);
%disp( [ '- num of initial matches: ' num2str(cdata.nInitialMatches) ] );
drawnow;
end