function [ distance overlap ] = compute_affinedistance( view1, view2, matchInfo , threshold_dist, bReflective  )
% function to compute affine projection error between initial matches
%
% Minsu Cho, Jungmin Lee, and Kyoung Mu Lee, 
% Feature Correspondence and Deformable Object Matching via Agglomerative Correspondence Clustering, 
% Proc. International Conference on Computer Vision (ICCV), 2009.
% 
% Note that this is a simple MATLAB implementation without consideration for speed-up. 
%
% written by Minsu Cho, 2009, Seoul National University, Korea
% http://cv.snu.ac.kr/~minsucho

if nargin < 4
    threshold_dist = 5;
end
if nargin < 5
    bReflective = 0;
end
threshold_sqdist = threshold_dist^2;    
bPair = ~strcmp(view1.fileName,view2.fileName);
nMatch = length(matchInfo);
distance = zeros(nMatch,nMatch);
if ~bPair
    distance_flip = zeros(nMatch,nMatch);
end
overlap = zeros(nMatch,nMatch);

for i=1:nMatch
    match_i = matchInfo(i).match;
    % Ti1: transform from normalized domain to region R1 of match i
    Ti1 = reshape(view1.affMatrix(match_i(1),:),[3 3])';
    % Ti2: transform from normalized domain to region R2 of match i
    Ti2 = reshape(view2.affMatrix(match_i(2),:),[3 3])';
    inv_Ti1 = inv(Ti1);    inv_Ti2 = inv(Ti2);

    % Ti21: transform from R1 to R2 
    % Ti12: transform from R2 to R1
    if bReflective
        Ti21 = Ti2*[ 1 0 0; 0 -1 0; 0 0 1 ]*inv_Ti1;
        Ti12 = Ti1*[ 1 0 0; 0 -1 0; 0 0 1 ]*inv_Ti2;
    else
        Ti21 = Ti2*inv_Ti1;        Ti12 = Ti1*inv_Ti2;
    end

    for j=1:nMatch
        if i == j,  continue;   end
        match_j = matchInfo(j).match;
        
        % Xj1: point P1 of match j,  Xj2: point P2 of match j
        Xj1 = view1.feat(match_j(1),1:2);   Xj2 = view2.feat(match_j(2),1:2);

        t_Xj1 = Ti21*[ Xj1 1 ]';    t_Xj1 = t_Xj1(1:2,1)'./t_Xj1(3,1);
        d1 = sqrt(sum((t_Xj1-Xj2).^2));
        t_Xj2 = Ti12*[ Xj2 1 ]';    t_Xj2 = t_Xj2(1:2,1)'./t_Xj2(3,1);
        d2 = sqrt(sum((t_Xj2-Xj1).^2));        
        distance(i,j) = ( d1 + d2 )/2;
        % when self-matching, we don't know where is head or tail,
        % so... make distances of flip match
        if ~bPair 
            t_Xj1 = Ti12*[ Xj1 1 ]';    t_Xj1 = t_Xj1(1:2,1)./t_Xj1(3,1);
            d3 = sqrt(sum((t_Xj1-Xj2').^2));
            t_Xj2 = Ti21*[ Xj2 1 ]';    t_Xj2 = t_Xj2(1:2,1)'./t_Xj2(3,1);
            d4 = sqrt(sum((t_Xj2-Xj1).^2));
            distance_flip(i,j) = ( d3 + d4 )/2;
        end
       
    end
end

% caculate mean projection errors and register overlapping matches
%unaryFactor = 0;

for i=1:nMatch
    match_i = matchInfo( i ).match;
    %unary_i = matchInfo(i).dist;
    for j=(i+1):nMatch
        match_j = matchInfo( j ).match;
        %unary_j = matchInfo(j).dist;
        %unaryDistance = max(unary_i, unary_j);
        if bPair
            %distance(i,j) = unaryFactor * unaryDistance + ( distance(i,j) + distance(j,i) )/2;
            distance(i,j) = ( distance(i,j) + distance(j,i) )/2;
            
            %bOverlap = any( match_i == match_j );
            dist_v(1) = sum(( view1.feat(match_i(1),1:2) - view1.feat(match_j(1),1:2) ).^2);
            dist_v(2) = sum(( view2.feat(match_i(2),1:2) - view2.feat(match_j(2),1:2) ).^2);
            overlap(i,j) = any( dist_v(1:2) < threshold_sqdist );
        else
            %distance(i,j) = unaryFactor * unaryDistance +...
            %    min(( distance(i,j) + distance(j,i) ), ( distance_flip(i,j) + distance_flip(j,i) ))/2;
            distance(i,j) = min(( distance(i,j) + distance(j,i) ), ( distance_flip(i,j) + distance_flip(j,i) ))/2;
            %bOverlap = ~isempty(intersect( match_i, match_j ));
            dist_v(1) = sum(( view1.feat(match_i(1),1:2) - view1.feat(match_j(1),1:2) ).^2);
            dist_v(2) = sum(( view1.feat(match_i(2),1:2) - view1.feat(match_j(2),1:2) ).^2);
            dist_v(3) = sum(( view1.feat(match_i(1),1:2) - view1.feat(match_j(2),1:2) ).^2);
            dist_v(4) = sum(( view1.feat(match_i(2),1:2) - view1.feat(match_j(1),1:2) ).^2);
            overlap(i,j) = any( dist_v(1:4) < threshold_sqdist );
        end
        distance(j,i) = distance(i,j);
        overlap(j,i) = overlap(i,j);
        
    end
end
